/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package products;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */

//This class is a subclass of Product
public class Pen extends Product implements WritingImplement, TaxableItem {
    
    //These are the properties specific to a Pen
    public PenType type;//Is it ball point, felt tip, etc?
    //The types of Pens
    public enum PenType {
        BALLPOINT("Ball-point Pen"),FELTTIP("Felt-tip Pen"),FOUNTAIN("Fountain or nib pen"),GEL("Gel Pen");
        public String name;

        private PenType(String name) {
            this.name = name;
        }
    }

    public void setType(String type) {
        switch (type) {
            case "Ball-point Pen":
                this.type=PenType.BALLPOINT;
                break;
            case "Felt-tip Pen":
                this.type=PenType.FELTTIP;
                break;
            case "Fountain or nib pen":
                this.type=PenType.FOUNTAIN;
                break;    
            case "Gel Pen":
                this.type=PenType.GEL;
                break;
        }
    }
    
    public Pen (String name) {
        super(name);
    }
    
    @Override
    public double calculateTax(){
        return price*0.05;
    }
}
